﻿using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupMakeAppointment
{
    public class MapPatGroupAppointmentRequestStep:FilterBase<MakeGroupAppointmentStateObject>
    {
        public override void Execute(MakeGroupAppointmentStateObject state)
        {
            state.PatEcRequest = new MakeAppointmentMapper().MapMakeAppointmentRequest(state, Side.Patient);
            var siteNum = state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_loginSiteCode;

            if (string.IsNullOrEmpty(state.PatUserDuz))
                state.PatLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SAMLToken);
            else
                state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = state.PatUserDuz;
        }
    }
}
